// midi.c

#include "main.h"
#include "midi.h"
#include "gworld.h"
#include "gameticks.h"
#include "about.h"
#include "soundfx.h"
#include "stringtools.h"
#include "graphics.h"
#include <string.h>
#include "mikmod.h"

const int kNoMusic = -1;

Boolean musicOn = true, musicFast = false;
int musicLevel = 0, musicSelection = kNoMusic;
MODULE *musicModule = NULL;

void InitMusic( void )
{
	MikMod_RegisterAllDrivers();
    MikMod_RegisterAllLoaders();

    md_mode |= DMODE_SOFT_MUSIC | DMODE_16BITS | DMODE_HQMIXER | DMODE_STEREO | DMODE_INTERP;
	md_mixfreq = 44100;

	if( MikMod_Init("") )
	{
		musicOn = false; 
		return;
	}
}

void FastMusic( void )
{
	if( musicModule && !musicFast )
	{
		Player_SetTempo( musicModule->inittempo * 1.3 );
		musicFast = true;
	}
}

void SlowMusic( void )
{
	if( musicModule && musicFast )
	{
		Player_SetTempo( musicModule->inittempo );
		musicFast = false;
	}
}

void PauseMusic( void )
{
	if( musicOn && musicSelection >= 0 && musicSelection <= kSongs )
	{
		if( musicLevel == 0 && !Player_Paused() ) Player_TogglePause( );
		musicLevel--;
	}
}

void ResumeMusic( void )
{
	if( musicOn && musicSelection >= 0 && musicSelection <= kSongs )
	{
		musicLevel++;
		if( musicLevel >= 0 )
		{
			musicLevel = 0;
			if( Player_Paused() ) Player_TogglePause( );
		}
	}
}

static void FSpSetAppFolder( FSSpec *fsSpec )
{
	FSSpec 					app, newFSSpec;
	ProcessSerialNumber 	psn = {0, kCurrentProcess};
	ProcessInfoRec 			info = {0};

	// get our process info
	info.processInfoLength  = sizeof(info);
	info.processName 		= nil;
	info.processAppSpec 	= &app;
	GetProcessInformation(&psn, &info);
	
	FSMakeFSSpec( app.vRefNum, app.parID, fsSpec->name, &newFSSpec );
	*fsSpec = newFSSpec;
}

static Boolean CreateMODFile( short resID, Str255 assignName )
{
	Handle resource;
	FSSpec fsSpec = { 0, 0, "\p" };
	ResType resType; 
	Str255 resName;
	Boolean success = false;
	long resSize;
	short refNum;
	
	resource = GetResource( '.mod', resID );
	if( resource ) 
	{
		HLock( resource );
		GetResInfo( resource, &resID, &resType, resName );
		CopyPString( fsSpec.name, assignName[0]? assignName: resName );
		FSpSetAppFolder( &fsSpec );
		
		resSize = GetResourceSizeOnDisk( resource );
		
		FSpDelete( &fsSpec );
		if( noErr == FSpCreate( &fsSpec, 'SCPL', 'STrk', smSystemScript ) )
		{
			if( noErr == FSpOpenDF( &fsSpec, fsRdWrPerm, &refNum ) )
			{
				FSWrite( refNum, &resSize, *resource );
				FSClose( refNum );
				success = true;
			}
		}

		ReleaseResource( resource );
	}
	
	return success;
}

void ChooseMusic( short which )
{
	FSSpec musicFile = { 0, 0, "\p.Candy Crisis temporary data" };

	if( musicModule && musicSelection >= 0 && musicSelection <= kSongs )	
	{
		Player_Stop();
		Player_Free( musicModule );
	}

	FSpSetAppFolder( &musicFile );
	
	musicSelection = kNoMusic;
	musicLevel     = 0;
	musicModule    = NULL;

	if( which >= 0 && which <= kSongs )
	{
		if( CreateMODFile( which + 128, musicFile.name ) )
		{
			musicModule = Player_Load( ".Candy Crisis temporary data", 64, 0 );
			musicModule->wrap = TRUE;
			FSpDelete( &musicFile );
			
			if( musicModule != NULL )
			{
				musicSelection = which;
				Player_Start(musicModule);
				if( !musicOn ) Player_TogglePause( );
			}
		}
	}
}

void SoundTest( void )
{
	DialogPtr myDialog;
	const int kOptionKey = 0x3a;
	short item, oldMusicSelection = musicSelection;

	if( context )
	{
		DSpContext_SetState( context, kDSpContextState_Paused );
	}

	FlushEvents( everyEvent, 0L );
	ArrowCursor( );
	
	ChooseMusic( kNoMusic );
	
	myDialog = GetNewDialog( dSoundTest, nil, kFirstWindowOfClass );
		
	SetPortDialogPort( myDialog );
	ShowWindow( GetDialogWindow(myDialog) );
	SetDialogDefaultItem( myDialog, ok );
	do
	{
		ModalDialog( nil, &item );
		
		if( (item >= 2) && (item <= (kSongs+2)) )
		{
			int music = item-2;
			
			if( !IsRegistered() && music >= 5 )
			{
				ChooseMusic(kNoMusic);
				PlayMono( kContinueSnd );
			}
			else
			{
				ChooseMusic( music );
					
				if( OptionKeyIsPressed() )
				{
					CreateMODFile( 128+music, "\p" );
				}
			}
		}
	}
	while( item != ok );
	
	DisposeDialog( myDialog );
	InvisiCursor( );

	ChooseMusic( oldMusicSelection );
	PauseMusic( );

	if( context )
	{
		DSpContext_SetState( context, kDSpContextState_Active );
		DSpContext_GetFrontBuffer( context, &backdropPort );
	}
}

